//___________________________________
//                                   \
// AI-nimation Movement algorithms extending Lithonite.  version 1.2 	$Id: ainimation.js 123 2008-07-28 22:38:46Z nilton $
//___________________________________/

/*
	To initialize this library:

	// First Lithonite has to be defined.
	RequireScript('lib/lithonite.js');
	var Lithonite= new LithoniteEngine("Lithonite"); // Can also be created after including ainimation.js
	// Now include the sprite animation library
	RequireScript('lib/ainimation.js');

	// Load the emotions spriteset. Each direction in the spriteset is a different emotion.
	// It will use each first letter of each direction, so if your spriteset has directions called "fume" and "Fall", 
	// you can emote by using this command string: Lithonite.AddCGMove(sprite,"#f"); and Lithonite.AddCGMove(sprite,"#F"); 	
	// You can call Lithonite.EmotionsInit(); to delete all loaded emotions.
	EMOTIONS.loadEmoticon("sfx/emoticons1.rss"); // Can be called multiple times to load multiple emotion spritesets.
	EMOTIONS.loadEmoticon("sfx/emoticons2.rss"); // Add also these emotions. (First letters should be different or it will replace them)

	// The ACTIONS object is like EMOTIONS, but you can tailor it at will (TODO: add Jump, hiccup, etc to this)
	// You can define your own actions letters like this:
	Actions['r'] = function(){ .... }
	// and run them like this:
	Lithonite.AddCGMove(sprite,"*r");
	// or, directly, like this:
    	QueuePersonScript(sprite, "Lithonite.ACTIONS['r']()", false);

	// Lithonite.ACTIONS['*'] = function(){DestroyPerson(GetCurrentPerson());} //Predefined, because EMOTIONS use it.
	// Destroy the current person, use like this:
	Lithonite.AddCGMove(sprite,"**");
	// or, directly, like this:
    	QueuePersonScript(sprite, "Lithonite.ACTIONS['r']()", false);


	//Integration with Plethora

        // ShortWrites. Note that nQ is a shortwrite defined for plethora. Read more there to understand nQ (which is a shortwrite for EventQueue.add() )

        // IgnorePersonObstructions, no repeat (added as a function). 'iobs' (Ignore person obstructions) defaults to true
	QMove = function(who, str, iobs) { nQ( Lithonite.AddCGMove, Lithonite, who, str, (typeof iobs!='undefined'?iobs:true), false); }

        // IgnorePersonObstructions, repeat (identical to QMove, except the last boolean is 'true', but added as a big string. Choose which method you like best)
        QLoop = function(who, str, iobs) { nQ("Lithonite.AddCGMove('" +who+ "',\"" +str+ "\","+(typeof iobs!='undefined'?iobs:true)+",true);"); }
	QLoop = function(who, str, iobs) { nQ( Lithonite.AddCGMove, Lithonite, who, str, (typeof iobs!='undefined'?iobs:true), true); }

        // Cancel all movement. this function also exists: Lithonite.ClearAllPersonCommandsAndCGMoves()
	QClear = function(who, immediate) { nQ(Game.lithonite.ClearCGMove, Game.lithonite, who, immediate); }


        // does not loop, same as "C" for AddCGMove(), but less demanding for CPU.
        sQ = function(who,dir,last) { nQ(Lithonite.NPCSequence, Lithonite, who, dir, last); }

        // Short-write some AInimation and Plethora functions (used in cutscenes.js).
        // To synchonize movements during a cutscene we set a marker to false, 
        // and then pause the EventQueue until its true.
	Set = function(c,n) { nQ("Lithonite.EventMarker['"+c+"']=" + n); }
        Neg = function(c) { nQ("Lithonite.EventMarker['"+c+"']=false"); }
        Pos = function(c) { nQ("Lithonite.EventMarker['"+c+"']=true"); }
        Nul = function(c) { nQ("Lithonite.EventMarker['"+c+"']=0"); }
	Zzz = function(c,n) { wQ("Lithonite.EventMarker['"+c+"']=="+(typeof n == "undefined"? true : n)); }


	A sprite can modify the eventmarkers with + = > < 
	and wait for them with = and ! (see AddCGMove for more information)

	TIPS:
	If you want to use SetPersonValue and GetPersonValue to store functions, run this code:

	SetPersonValue_=SetPersonValue;
	GetPersonValue_=GetPersonValue;

	SetPersonValue=function(sprite,variable,value){
        	if (typeof value=='function'){
	                if(!SetPersonValue.func[sprite])
        	                SetPersonValue.func[sprite] = new Object();
	                SetPersonValue.func[sprite][variable]=value;
        	}else{
                	SetPersonValue_(sprite,variable,value);
	        }
	};
	SetPersonValue.func=new Object();

	GetPersonValue=function(sprite,variable){
        	if(SetPersonValue.func[sprite] && SetPersonValue.func[sprite][variable])
	                return SetPersonValue.func[sprite][variable];
        	else
                	return GetPersonValue_(sprite,variable);
	}

*/

/**
 * Array, here we hold temporal flags used to synch personscripts.
 */
LithoniteEngine.prototype.EventMarker = new Array();
LithoniteEngine.prototype.ClearEventMarker = function(){ this.EventMarker = [];}

//not very useful functions (makes for good interface functions when EventMarker becomes hidden):
//function IsEventMarker(eventlabel,eventvalue) { return( Lithonite.EventMarker[eventlabel]==eventvalue); }
//function SetEventMarker(eventlabel,eventvalue) { return( Lithonite.EventMarker[eventlabel]=eventvalue); }
//function GetEventMarker(eventlabel) { return( Lithonite.EventMarker[eventlabel] ); }

/**
 * Object with functions or strings (which can be be used in SetCGMove() )
 */
LithoniteEngine.prototype.ACTIONS = {};

/**
 * Object that will hold Spritesets with 'emotions', initialized by EmotionsInit();
 */
LithoniteEngine.prototype.EMOTIONS = {};

/**
 * Initialize the EMOTIONS object, this function is already called in this library. Call it again to reset the EMOTIONS Object.
 */

LithoniteEngine.prototype.EmotionsInit = function(){

	// Used by Emoticons to autodestruct (define it again, just in case).
	this.ACTIONS['*'] = function(sprite){DestroyPerson(sprite||GetCurrentPerson());}

	this.EMOTIONS= {
		/**
		 * Object to hold multiple Spritesets
		 */
		rss: Object(),

		/**
		 * Loads a spriteset as emotions, create functions, based on the first letter of the directions, that can be used by AddCGMove()
		 * @param {string} rss Name of a spriteset
		 * @param {Boolean} emoticonFollowsSprite If the spawned person follows the person in emotion, or not.
		 */
		loadEmoticon: function(rss,emoticonFollowsSprite) {
			this.rss[rss] = LoadSpriteset(rss);
			if(emoticonFollowsSprite)
				this.emoticonFollowsSprite = emoticonFollowsSprite;
			var dir;
			var i = this.rss[rss].directions.length-1;
			do{
				dir = this.rss[rss].directions[i].name;
				if( !this[dir[0]] ){
					this[dir[0]]= new Function( "person",
						"person = person || GetCurrentPerson();" +
						"var emote = this.setEmoticon('"+rss+"','"+dir+"',person);" +
						"this.reposEmoticon(emote, person);" +
						"return emote;"
					);
					this[dir] = this[dir[0]];
				}
			}while(i--);
		},

		/**
		 * Makes a person emote. Animate one full sequence once and destroys itself, ignore obstructions, dont repeat.
		 * @param {string} rss Name of a spriteset
		 * @param {string} direction Direction of the emotion
		 * @param {string} person Person which emotes, leave empty if called inside a personscript
		 * @returns the name of the emoticon, which can be fed to reposEmoticon()
		 */
		setEmoticon: function(rss,direction,person) {
			person = person || GetCurrentPerson();
			var emote = 'emote' + person + GetTime();
			CreatePerson(emote,"sfx/empty.rss",true); //load a small and fast dummy rss
			SetPersonSpriteset(emote,this.rss[rss]); //replace that dummy rss with the real thing.
			SetPersonDirection(emote,direction);
			SetPersonLayer(emote,GetNumLayers()-1);
			if(this.emoticonFollowsSprite){
				var offsetY = -GetPersonSpriteset(person).images[0].height;
				this.parent.SCG_Chain(emote,this.parent.objname+'.reposNextTo("'+person+'",0,'+offsetY+',"'+emote+'",true);');
			}
			this.parent.AddCGMove(emote,"C**",true,false,true);
			return emote;
		},

	        /**
        	 * Set the emoticon just above the current person
		 * @param {string} emote Name of the emoticon
		 * @param {string} person Name of the person which is in emotion.
		 */
		reposEmoticon: function(emote,person) {
			this.parent.reposNextTo(person, 0, -GetPersonSpriteset(person).images[0].height, emote, true);
		},

		emoticonFollowsSprite: new Boolean(false)

	}

	this.EMOTIONS.parent=this;
}

//LithoniteEngine.prototype.EmotionsInit(); //Call this to reset/initialize the emotions

/**
 * Define some default actions
 */
LithoniteEngine.prototype.ActionsInit = function(){

	this.ACTIONS = {

		/**
		 * Makes a person selfdestruct. use like this: AddCGMove(sprite,"**");
		 * @param {string} sprite Name of the Person ( You can use 0, false or undefined as the value for sprite if you mean GetCurrentPerson() )
		 */
		'*' : function(sprite){DestroyPerson(sprite||GetCurrentPerson());}, //Used by Emoticons to autodestruct.

		/**
		 * Quick Recenter, no checks, so you really should use Phenibut's Lithonite.recenter(); instead
		 * @param {string} sprite Name of the Person ( You can use 0, false or undefined as the value for sprite if you mean GetCurrentPerson() )
		 * Call in CGMove: 
		 *  AddCGMove(sprite,"*+"); 
		 * or directly: 
		 *  Lithonite.ACTIONS['+']("hero");
		 */
		'+' : function(sprite){ sprite=sprite||GetCurrentPerson(); SetPersonXYFloat(sprite, ((GetPersonXFloat(sprite)>>4)<<4)-1+(GetTileWidth()>>1), ((GetPersonYFloat(sprite)>>4)<<4)-1+(GetTileHeight()>>1)); },

		/**
		 * Makes a person hiccup with AddCGMove(sprite,"*H");
		 * Some warnings: the spritebase offsets when you change the ScaleFactor (in older versions, it rescaled).
		 * You also can get a jumpy camera (not verified in this version of Sphere)
		 * Use Esthetica's hiccup if this worries you, which unfortunately will not check if the sprite exists (after a mapchange, for example).
		 * @param {string} sprite Name of the Person ( You can use 0, false or undefined as the value for sprite if you mean GetCurrentPerson() )
		 */
		'H' : function(sprite){
			sprite = sprite||GetCurrentPerson();
			var hd= GetPersonValue(sprite,'_hd'); //Get the hiccup delay
			if(hd) return; // no multiple hiccups
			SetPersonValue(sprite,'_hd',5); //Set the hiccup delay

			var XX=GetPersonX(sprite)+GetPersonSpriteset(sprite).images[0].width*(0.1);
		        var YY=GetPersonY(sprite)-GetPersonSpriteset(sprite).images[0].height*(0.07)-1;
		        SetPersonValue(sprite,'_hx',GetPersonX(sprite));
		        SetPersonValue(sprite,'_hy',GetPersonY(sprite));
			this.parent.SCG_Chain(sprite,this.parent.objname+'.ACTIONS.checkHiccup();');

			SetPersonScaleFactor(sprite, 0.8,1.15);
			SetPersonXYFloat(sprite,XX,YY);
		},

		/**
		 * Helper function for ACTIONS['H'](), will restore the original ScaleFactor.
		 */
		checkHiccup : function(){
			var sprite = GetCurrentPerson();
			var hd= GetPersonValue(sprite,'_hd'); //Get the hiccup delay
			if(hd>0) {SetPersonValue(sprite,'_hd',--hd); return;}
			this.parent.SCG_unChain(sprite,this.parent.objname+'.ACTIONS.checkHiccup();');
		        SetPersonScaleFactor(sprite, 1,1);
		        SetPersonXYFloat(sprite,GetPersonValue(sprite,'_hx'),GetPersonValue(sprite,'_hy'));
		}
	}
	this.ACTIONS.parent=this;
}
//----------------------------------------------------------------------------//

/**
 * Will run a commandstring when the person becomes not obstructed. Like {@link LithoniteEngine#testFromUntil} but with a fixed condition.
 * @param {integer} delayCounter Will start testing in 'delayCounter' frames
 * @param {string} person Name of the person 
 * @param {string} runCommand Command string that will run as soon as condition is true
 * @param {integer} retryDelay If the condition is false, it will test again in 'retryDelay' frames. The default is 1.
 * @param {integer} retryCounter This tells us how many times we can use the retryDelay, infinite times by default (undefined value)
 * @param {Boolean} immediate If true, it will execute runCommand immediately, else it will delay one frame. Defaults to true
*/
LithoniteEngine.prototype.whenPersonNotObstructed = function(delayCounter,person,runCommand,retryDelay,retryCounter,immediate) {
	if(retryCounter!=undefined && (retryCounter--<0))
		return;
	if(delayCounter>0) {
		SetDelayScript(delayCounter, this.objname+".whenPersonNotObstructed(0,\""+person+"\",\""+runCommand+"\","+retryDelay+","+(retryCounter+1)+");");
		return;
	}
	var doIgnoreSet = IsIgnoringPersonObstructions(person);
	IgnorePersonObstructions(person, false);
	var cond = IsPersonObstructed(person,GetPersonX(person),GetPersonY(person));
	if(doIgnoreSet)
		IgnorePersonObstructions(person, true);

	if(cond){ 
		SetDelayScript(retryDelay||1, this.objname+".whenPersonNotObstructed(0,\""+person+"\",\""+runCommand+"\","+retryDelay+","+retryCounter+","+immediate+");");
		return;
	}
	if(immediate==undefined)
		immediate=true;
	if(immediate)
		eval(runCommand);
	else
		SetDelayScript(1,runCommand);
}

//----------------------------------------------------------------------------//
/**
 * Will infinitely cycle a person through its frames. Clock-time dependant looping sequence, it ignores the frame delays defined in the spriteset.
 * @param {integer} delay The frame delay. 1: very fast, 1000: very slow
 * @param {integer} maxframes The amount of frames the direction you set the person to has.
 * Usage example: First set the direction of your person, then put this in the SCRIPT_COMMAND_GENERATOR: Lithonite.NPCMove(7,5);
 */
LithoniteEngine.prototype.NPCMove = function(delay,maxframes) {SetPersonFrame(GetCurrentPerson(),(GetTime()>>delay)%maxframes);}

/**
 * Will infinitely cycle through the frames of a person direction, honouring the frame delays defined in the spriteset.
 * @param {string} person Name of the Person ( You can use 0, false or undefined as the value for person if you mean GetCurrentPerson() )
 * @param {string} newdirection A new direction. Optional. Set it if its not already in the direction it should animate.
*/
LithoniteEngine.prototype.NPCAnimate = function(person,newdirection){
  person = person||GetCurrentPerson();
  if(newdirection)
  	SetPersonDirection(person,newdirection);
  SetPersonScript(person, SCRIPT_COMMAND_GENERATOR, "QueuePersonCommand(GetCurrentPerson(),COMMAND_ANIMATE,false);");
}

/**
 * Will cycle only once through the frames of a person direction, honouring the frame delays defined in the spriteset.
 * @param {string} person Name of the Person ( You can use 0, false or undefined as the value for person if you mean GetCurrentPerson() )
 * @param {string} newdirection A new direction. Optional.
 * @param {Boolean} last Stay on the last frame of the animation, instead of reverting to frame 0. Defaults to false.
*/
LithoniteEngine.prototype.NPCSequence = function(person,newdirection,last) {
	person = person||GetCurrentPerson();
	newdirection = newdirection||GetPersonDirection(person);
	SetPersonDirection(person,newdirection);
	SetPersonFrame(person,0);
	var Delay=this.getSeqTimes(person,newdirection);
	if(last) --Delay;
	do{
		QueuePersonCommand(person, COMMAND_ANIMATE, false);
	}while(--Delay);
}

/**
 * Returns the frames (minus 1) it takes for a full animation of a certain direction.
 * The first time, it penalizes by storing the retrieved value to ST_<direction> inside the person, after that, its fast.
 * @param {string} person Name of the Person ( You can use 0, false or undefined as the value for person if you mean GetCurrentPerson() )
 * @param {string} newdirection A new direction. Optional.
 * @returns the frames it takes for a full animation in the given direction. 0 if that direction doesnt exists.
 * If you need to know how many images a certain direction has, then use: SetPersonDirection(person,<direction>); n = GetPersonValue(person,'num_frames');
 */
LithoniteEngine.prototype.getSeqTimes=function(person,newdirection){
	person = person||GetCurrentPerson();
	newdirection = newdirection||GetPersonDirection(person);
	var Delay = GetPersonValue(person,"ST_"+newdirection);
	if(Delay)
		return Delay;
	Delay=-1;
	var i2=0;
	var spr=GetPersonSpriteset(person);
	var sdl=spr.directions.length;
	while ( (i2 < sdl) && 
		!(spr.directions[i2].name == newdirection) ) 
	{++i2;}  //Search spr's same direction
	if(i2<sdl)  //rss does have this direction
	{
		var mydir = spr.directions[i2].frames;
		var frame=mydir.length-1;
		do{ Delay+= mydir[frame].delay; }while(frame--);
		SetPersonValue(person,"ST_"+newdirection,Delay);
		return Delay;
	}
	//else LogWarn("Direction "+newdirection+" for "+person+" not found.");
	return 0;
}


//----------------------------------------------------------------------------//

/**
 * Stores a command string into the person data. This string can then be executed by an AddCGMove() command.
 * With & you QueuePersonScript(), with _ you eval, with / you run a function. See {@link AddCGMove}
 * @param {string} sprite Name of the sprite
 * @param {char} cmdlabel Command character to store the information to.
 * @param {string} cmd A command string or (unnamed) function without parameters
 * note: If you try to store a function, it is actually stored inside Lithonite.ACTIONS, not inside the person.
 */
LithoniteEngine.prototype.StorePersonCmd = function(sprite,cmdlabel,cmd) {
	if(typeof cmd=='function'){
		this.ACTIONS[sprite+":"+cmdlabel]=cmd;
	}else{
		SetPersonValue(sprite, 'cmd_'+cmdlabel, cmd);
	}
}

/**
 * Stores a person direction into the person data. This direction can then be set by an AddCGMove() command.
 * Used by {@link AddCGMove}, with the following cmds:  ; . ( ) and ^ (last one requires Lithonite)
 * @param {string} sprite Name of the sprite
 * @param {char} dirlabel Dir character to store the information to.
 * @param {string} dirstring A direction defined in the SpriteSet, or part of a direction, if set for "^"
 */
LithoniteEngine.prototype.StorePersonDir = function(sprite,dirlabel,dirstring) {
	SetPersonValue(sprite, 'dir_'+dirlabel, dirstring);
}
	
/**
 * Stores the text for a rethorica textballoon
 * @param {string} sprite Name of the sprite
 * @param {char} textlabel Text character to store the information to.
 * @param {string} textstring The string the character will say
 * @param {integer} numframes How many frames this textstring will be displayed
 * @param {integer} bx The balloon arrow X offset. See {@link StorePersonTextBxy}
 * @param {integer} by The balloon arrow Y offset. See {@link StorePersonTextBxy}
 */
LithoniteEngine.prototype.StorePersonText = function(sprite,textlabel,textstring,numframes,bx,by) {
	SetPersonValue(sprite, 'txt_'+textlabel, textstring);
	if(numframes)
		this.StorePersonTextFrames(sprite,textlabel,numframes);
	if(bx||by)
		this.StorePersonTextBxy(sprite,bx,by);
}

/**
 * Helper function. Stores the frames the text for 'textlabel' will be displayed.
 * @param {string} sprite Name of the sprite
 * @param {char} textlabel Text character to store the information to.
 * @param {integer} numframes How many frames the textstring for 'textlabel' will be displayed
 */
LithoniteEngine.prototype.StorePersonTextFrames = function(sprite,textlabel,numframes) {
	SetPersonValue(sprite, 'fra_'+textlabel, numframes);
}

/**
 * Stores the offset of where the balloon arrow points to. (0,0) will be the center of the spritebase.
 * (-16,-40) is upper left, (16,16) is lower right. Default is (-16,16) lower left.
 * @param {string} sprite Name of the sprite
 * @param {integer} bx The balloon arrow is moved in the X axis (for all balloons to come). Default is -16
 * @param {integer} by The balloon arrow is moved in the Y axis (for all balloons to come). Default is 16
 */
LithoniteEngine.prototype.StorePersonTextBxy = function(sprite,bx,by) {
	SetPersonValue(sprite, 'bX', bx);
	SetPersonValue(sprite, 'bY', by);
}


//----------------------------------------------------------------------------//

/**
 * Clears, then sets the movement string for an NPC. 
 * @param {string} sprite Name of the sprite
 * @param {string} mstr Movement string, see {@link AddCGMove} on what to put here
 * @param {Boolean} doIgnorePersonObstructions While moving, ignore PersonObstructions
 * @param {Boolean} repeat
 * @param {Boolean} doIgnoreTileObstructions While moving, ignore TileObstructions
 *
 * Usage example. 
 * Define in SCRIPT_ON_CREATE:
 *    SetCGMove(GetCurrentPerson(),'WwwSssEeeNnn',false,true);
 * Will make the NPC walk in circles. To get him out of this loop, just call:
 *    AddCGMove(GetCurrentPerson(),'S',false,false);
 * This will set looping to false, then it will end the Sequence WwwSssEeeNnn and 
 * just because we appended S, face to the South.
 * This would also have worked:
 *    SetCGMove(GetCurrentPerson(),'S',false,false);
 * But the NPC would have stopped immediately somewhere along its circle-path then faced south.
 */
LithoniteEngine.prototype.SetCGMove = function(sprite,mstr,doIgnorePersonObstructions,repeat, doIgnoreTileObstructions){
	SetPersonValue(sprite, 'mstr',"");
	SetPersonValue(sprite, 'factor',0);
	this.AddCGMove(sprite,mstr,doIgnorePersonObstructions,repeat, doIgnoreTileObstructions);
}

//----------------------------------------------------------------------------//

/**
 * One of the most versatile functions to animate a Person. You define it as a String.
 * @param {string} sprite Name of the person that we want to move/animate 
 * @param {string} mstr Movement string, the commands the sprite will run.
 * @param {Boolean} doIgnorePersonObstructions If the person ignores obstructions (it will wait when obstructed). False by default.
 * @param {Boolean} repeat True if the commands in mstr have to be repeated.
 * @param {Boolean} doIgnoreTileObstructions If the person ignores tile obstructions (it will wait when obstructed). False by default.
 *
 * How to write the mstr. All of the following letters can have an optional number to make it repeat n times:
 *
 * "N", "E", "S", "W": Faces North/East/South/West.
 * "Q", "O", "M", "Z": Faces North-West/North-East/South-East/South-West.
 * "H", "p", "h": Waits a full time(16)/halftime(8)/one time(1)
 * "A", "a", "C": Animates a full time/one time/complete Sequence in the direction the Person is currently in.
 * "n", "e", "w", "s": Moves North/East/South/West (one full tile).
 * "q", "o", "m", "z": Moves North-West/North-East/South-East/South-West (tiles, also).
 * "U", "R", "D", "L": Up/Right/Down/Left. Sets the special directions: face_north, face_east, etc.
 * "T", "Y", "B", "V": Sets the special directions: face_northwest, face_northeast, face_southeast, face_southwest.
 * "u", "r", "d", "l": moves North/East/South/West (like n/e/w/s), but only one pixel instead of a full tile.
 *
 * The following commands take a character as parameter, which can be any ascii character you'd like:
 *
 * "."+c: Sets the direction 'c', which had been defined in: Lithonite.StorePersonDir(sprite,c,"myDirectionHere")
 * ";"+c: Sets the direction 'c', then sets frame 0
 * ","+c: Sets the frame to SetPersonFrame(sprite,c). Note that the frames start at 0.
 * "("+c: Stores the current direction and frame into c.
 * ")"+c: Restores the direction and frame stored in c.
 * "^"+c: SwapDirection: Sets the direction 'c', which had been defined in: Lithonite.StorePersonDir(sprite,c,"myDirectionHere")
 *        Note that this 'direction' is just a substring, so if you have face_north, your dir is "face_"
 *        It looks like this symbol cant be directly in a string, put a backslash before it, like so: "\^c"
 * "&"+c: QueuePersonScript() script 'c', which had been defined with: Lithonite.StorePersonCmd(sprite,c,"myCmdStringHere")
 * "_"+c: Evals the script 'c', which had been defined with: Lithonite.StorePersonCmd(sprite,c,"myCmdStringHere")
 *        The difference between & and _ is that _ can use the variable 'sprite' as the currentperson, and
 *        all Personvalues are in the array 'd', so you can access/store things: d['move_y']; d['hello']=2;
 *        If you dont need that, just use '&'.
 * "/"+c: runs the function 'c', which had been defined with: Lithonite.StorePersonCmd(sprite,c, new Function("myCmdStringHere") )
 *        functions are faster than eval (& and _), so you might prefer it. Functions are not really stored in the person.
 *
 * The following commands take a character as parameter, and are used to synchonize movements between persons and other events
 * Variables are stored in the array EventMarker[].
 *
 * "+"+c: Sets the eventmark 'c' to true.
 * "-"+c: Sets the eventmark 'c' to false.
 * "<"+c: Increases the eventmark 'c' by one.
 * ">"+c: Decreases the eventmark 'c' by one.
 * "="+c: Waits until the eventmark 'c' is true.
 * "!"+c: Waits until the eventmark 'c' is false.
 *
 * The following command calls a rethorica textballoon
 * "?"+c: You first store the text and placement with: Lithonite.StorePersonText(sprite,textlabel,textstring,numframes,bx,by)
 *        Where textlabel is the value of 'c', textstring is what you want to say, numframes is how many frames this
 *        balloon is displayed and bx,by are the offset of the balloon. try (-16,16) for a balloon below and (-16,-32) 
 *        for a balloon on top of your sprite. Note that you can only have one single value of bx and by for 
 *        all textlabels for a certain sprite.
 *        example: Lithonite.StorePersonText(hero,'c', 'This is a text',16);
 *        And then display it by using this command string: "?c"
 *        Sprites can display their single balloon all at once
 *
 * These commands are for global events that are started from within a command string.
 *
 * "*"+c: Will run the function ACTIONS['c']();
 * "#"+c: Will show an emoticon 'c'. See EMOTIONS object in this file for some examples. 
 *
 * The following commands take a number as parameter:
 *
 * "["+n: Increase SetPersonSpeed with n*0.25. So to increase the speed by 1, use: {4
 * "]"+n: Decrease SetPersonSpeed with n*0.25. So to decrease the speed by 2, use: }8
 * "{"+n: Set the person angle to  n/16 (steps of 22.5 degrees). {0 sets the angle to zero, {8 reverses the sprite.
 * "}"+n: Set the person angle to -n/16 (steps of 22.5 degrees). Use a-z for steps of 4.5 degrees. example: }b and {z
 * 
 * If a person is still processing its movement string, then GetPersonValue(person, 'moving') == true
 */
LithoniteEngine.prototype.AddCGMove = function(sprite, mstr, doIgnorePersonObstructions, repeat, doIgnoreTileObstructions) {
	this.SCG_Chain(sprite,this.objname+'.DoMove("'+sprite+'");');

	var d = GetPersonData(sprite);
	d['cgmove'] = true;
	if(d['mstr']){ //Continue, append the new mstr, and flag, we'll trim it later
		d['mstr_cutme'] = d['pos'];
		d['mstr'] += mstr;
	}else{ // new string
		d['mstr'] = mstr;
		d['pos'] = 0;
		d['step'] = 0;
		d['factor'] = 0;
		if(d['noidle']===undefined) d['noidle'] = 0;
		d['old_IgnorePersonObstructions'] = IsIgnoringPersonObstructions(sprite);
		d['doIgnorePersonObstructions'] = false;
		d['old_IgnoreTileObstructions'] = IsIgnoringTileObstructions(sprite);
		d['doIgnoreTileObstructions'] = false;
		if(sprite == this.GIP) {
			if(IsInputAttached())	{
				DetachInput();
				d['reattachInput'] = true;
			}else{
				d['reattachInput'] = false;
			}
			this.moving = 2;
		}
	}

	d['repeat'] = repeat;
	if(doIgnorePersonObstructions){
		d['doIgnorePersonObstructions'] = true;
		IgnorePersonObstructions(sprite, true);
	}
	if(doIgnoreTileObstructions){
		d['doIgnoreTileObstructions'] = true;
		IgnoreTileObstructions(sprite, true);
	}
	d['move_xx'] = d['move_xx']||0;
	d['move_yy'] = d['move_yy']||0;
	SetPersonData(sprite,d);
}

//----------------------------------------------------------------------------//
/**
 * Clears the mstr command string given with {@link AddCGMove}
 * @param {string} sprite Name of the person
 * @param {Boolean} immediate True if you want to also clear the person's Command Queue
 * @param {persondata} d If you already have the persondata, pass it along. Optional.
 * note: In addition, you might also want to: SetPersonScript(sprite, SCRIPT_COMMAND_GENERATOR, "");
 */
LithoniteEngine.prototype.ClearCGMove = function(sprite,immediate,d) {
	if(immediate && !IsCommandQueueEmpty(sprite))
		ClearPersonCommands(sprite);
	this.SCG_unChain(sprite,this.objname+'.DoMove("'+sprite+'");');
	if(!d) d = GetPersonData(sprite);
	d['mstr'] = "";
	d['cgmove'] = false;
	d['moving'] = 0;
	d['repeat'] = false;
	if(sprite == this.GIP) {
		if(d['reattachInput']){
			AttachInput(sprite);
			d['reattachInput'] = false;
		}
		if(d['noidle'])
			this.moving = 2;
		else
			this.moving = 0;
	}
	if(d['doIgnorePersonObstructions']){
		d['doIgnorePersonObstructions'] = false;
		IgnorePersonObstructions(sprite, d['old_IgnorePersonObstructions']);
	}
	if(d['doIgnoreTileObstructions']){
		d['doIgnoreTileObstructions'] = false;
		IgnoreTileObstructions(sprite, d['old_IgnoreTileObstructions']);
	}
	SetPersonData(sprite,d);
}

/**
 * runs {@link ClearCGMove} for all persons
 * @param {Boolean} immediate True if you want to also clear the person's Command Queue
 */
LithoniteEngine.prototype.ClearAllPersonCommandsAndCGMoves = function(immediate){
	//ClearDelayScript();
	var Persons=GetPersonList();
	var i=Persons.length-1;
	do {
		this.ClearCGMove(Persons[i],immediate);
	} while (i--);
}

//----------------------------------------------------------------------------//

/**
 * Add a string to a person's SCRIPT_COMMAND_GENERATOR.
 * It is done in a way that the cmd string will only be added once.
 * @param {string} sprite Name of the person
 * @param {string} cmd The command to append. It needs to end with ;
 */
LithoniteEngine.prototype.SCG_Chain = function(sprite,cmd){
	var str= GetPersonScript(sprite,SCRIPT_COMMAND_GENERATOR)||"";
	//if(cmd.substr(cmd.length-1,1) != ";") cmd=cmd.concat(";"); //chained commands always end with ;
	SetPersonScript(sprite, SCRIPT_COMMAND_GENERATOR, str.replace(cmd,"").concat(cmd));
	//SetPersonValue( sprite,SCRIPT_COMMAND_GENERATOR,str.concat(cmd)); //Already done by redefined SetPersonScript()
}

/**
 * Removes a string from a person's SCRIPT_COMMAND_GENERATOR.
 * @param {string} sprite Name of the person
 * @param {string} cmd The command to remove. It needs to end with ;
 */
LithoniteEngine.prototype.SCG_unChain = function(sprite,cmd){
	var str= GetPersonScript(sprite,SCRIPT_COMMAND_GENERATOR)||"";
	SetPersonScript(sprite,SCRIPT_COMMAND_GENERATOR, str.replace(cmd,"") );
}



//----------------------------------------------------------------------------//

//DoChase(GetCurrentPerson(),MainChar);

/**
 * Makes a person chase another person
 * @param {string} sprite Name of the person that will chase
 * @param {string} who Name of the person that will be chased
 * @param {integer} tilesize Size of the tiles, defaults to 16
 */
LithoniteEngine.prototype.DoChase = function(sprite,who,tilesize){
	var d = GetPersonData(sprite);
	if(d['mstr']==undefined){
		d['mstr']="";
		d['pos']=-1;
		d['repeat']=true;
		d['step']=0;
		d['move_x']=d['move_y']=0
	}
	if(d['mstr'].length < d['pos']||d['mstr']==''||d['pos']==2){
		d['pos'] = 0;
		d['mstr'] = this.StepToPerson(sprite,who,tilesize||16);
		SetPersonData(sprite,d);
	}
	if(!this.DoMove(sprite)){
		d = GetPersonData(sprite);
		ClearPersonCommands(sprite)
		d['mstr'] = this.StepToPerson(sprite,who,1);
		d['step'] = 0;
		SetPersonData(sprite,d);
		if(GetObstructingPerson(sprite, d['move_x'],d['move_y'])==who)
			return true;
		this.deObstructNPC(sprite,d['move_x'],d['move_y']);
	}
	return false;
}

//----------------------------------------------------------------------------//

/**
 * Internal function used by {@link AddCGMove}. This function is added to the SCRIPT_COMMAND_GENERATOR of a person.
 */
LithoniteEngine.prototype.DoMove = function(sprite) {
	//  if(!doIgnorePersonObstructions && IsPersonObstructed(sprite, GetPersonX(sprite),GetPersonY(sprite))) return;
	var d=GetPersonData(sprite);

	//Read+Decode a new direction
	if(!d['step'])
		this.DoMoveCalc(sprite,d);

	if(!d['mstr'])
		return 0;

	d['x'] = GetPersonXFloat(sprite);
	d['y'] = GetPersonYFloat(sprite);

	if(IsPersonObstructed(sprite, d['x']+d['move_xx'],d['y']+d['move_yy'])){
		SetPersonData(sprite,d);
		return 0; //If we are obstructed, just wait...
	}
	//Now MOVE!
	switch(d['c']) {
		case "N": QueuePersonCommand(sprite, COMMAND_FACE_NORTH, true); break;
		case "E": QueuePersonCommand(sprite, COMMAND_FACE_EAST, true);  break;
		case "S": QueuePersonCommand(sprite, COMMAND_FACE_SOUTH, true); break;
		case "W": QueuePersonCommand(sprite, COMMAND_FACE_WEST, true);  break;
		case "Q": QueuePersonCommand(sprite, COMMAND_FACE_NORTHWEST, true); break;
		case "O": QueuePersonCommand(sprite, COMMAND_FACE_NORTHEAST, true); break;
		case "M": QueuePersonCommand(sprite, COMMAND_FACE_SOUTHEAST, true); break;
		case "Z": QueuePersonCommand(sprite, COMMAND_FACE_SOUTHWEST, true); break;

		case "H": case "h": case "p": QueuePersonCommand(sprite, COMMAND_WAIT, false); break;
		case "C": case "A": case "a": QueuePersonCommand(sprite, COMMAND_ANIMATE, false); break;

		case "q": QueuePersonCommand(sprite, COMMAND_MOVE_WEST, true);
		case "n": case "u":QueuePersonCommand(sprite, COMMAND_MOVE_NORTH, true);break;
		case "o": QueuePersonCommand(sprite, COMMAND_MOVE_NORTH, true);
		case "e": case "r":QueuePersonCommand(sprite, COMMAND_MOVE_EAST, true); break;
		case "m": QueuePersonCommand(sprite, COMMAND_MOVE_EAST, true);
		case "s": case "d":QueuePersonCommand(sprite, COMMAND_MOVE_SOUTH, true);break;
		case "z": QueuePersonCommand(sprite, COMMAND_MOVE_SOUTH, true);
		case "w": case "l":QueuePersonCommand(sprite, COMMAND_MOVE_WEST, true); break;

		case "U": SetPersonDirection(sprite,this.face+'north'); break;
		case "R": SetPersonDirection(sprite,this.face+'east');  break;
		case "D": SetPersonDirection(sprite,this.face+'south'); break;
		case "L": SetPersonDirection(sprite,this.face+'west');  break;
		case "T": SetPersonDirection(sprite,this.face+'northeast');  break;
		case "Y": SetPersonDirection(sprite,this.face+'northwest');  break;
		case "B": SetPersonDirection(sprite,this.face+'southwest');  break;
		case "V": SetPersonDirection(sprite,this.face+'southeast');  break;

		case "J": d['spd_x']=GetPersonSpeedX(sprite); d['spd_y']=GetPersonSpeedY(sprite);break;
		case "K": SetPersonSpeedXY(d['spd_x'], d['spd_y']);break;

		case ";": SetPersonDirection(sprite,d['dir_'+d['p']]); SetPersonFrame(sprite,0); break;
		case ".": SetPersonDirection(sprite,d['dir_'+d['p']]); break;
		case ",": SetPersonFrame(sprite,d['p']); break;
		case "'": this.moving=0;this.standStill(0,sprite);this.moving=2; --d['pos']; break;
		case "~": d['noidle']=d['p']; break;
		case "(": d['dir_'+d['p']]=GetPersonDirection(sprite); d['frame_'+d['p']]=GetPersonFrame(sprite); break;
		case ")": SetPersonDirection(sprite,d['dir_'+d['p']]);SetPersonFrame(sprite,d['frame_'+d['p']]); break;
		case "&": QueuePersonScript(sprite, d['cmd_'+d['p']], false); break;
		case "_": eval(d['cmd_'+d['p']]); break;
		case "+": this.EventMarker[d['p']]=true; break;
		case "-": this.EventMarker[d['p']]=false; break;
		case "<": ++this.EventMarker[d['p']]; break;
		case ">": --this.EventMarker[d['p']]; break;
		case "=": if(!this.EventMarker[d['p']]){QueuePersonCommand(sprite, COMMAND_WAIT, false); ++d['step'];}; break;
		case "!":  if(this.EventMarker[d['p']]){QueuePersonCommand(sprite, COMMAND_WAIT, false); ++d['step'];}; break;
		case "^": this.SwapDirections(d['dir_'+d['p']], sprite, true); break;
		case "/": this.ACTIONS[sprite+":"+d['p']](); break;
		case "[": SetPersonSpeed(sprite, GetPersonSpeedX(sprite)+(d['p']/4)); break;
		case "]": SetPersonSpeed(sprite, GetPersonSpeedX(sprite)-(d['p']/4)); break;
		case "{": if(d['p'].charCodeAt(0)>96) SetPersonAngle(sprite, this.p8[1]*(d['p'].charCodeAt(0)-96)/5); else SetPersonAngle(sprite,  this.p8[d['p']]); break;
		case "}": if(d['p'].charCodeAt(0)>96) SetPersonAngle(sprite, this.p8[1]*(96-d['p'].charCodeAt(0))/5); else SetPersonAngle(sprite, -this.p8[d['p']]); break;
		case "%": break; //TextBox with picture.
		case "$": break; //Textbox without picture
		case "@": break; //unused, reserved
		case ":": break; //unused, reserved (I take suggestions)
		case "|": break; //unused, reserved (I take suggestions)
		case "?": Rethorica.addBalloon(sprite); d['bmsg']=d['txt_'+d['p']]; d['bfra']=d['fra_'+d['p']]; break;

		case "*": if(typeof this.ACTIONS[d['p']] =='function') QueuePersonScript(sprite, this.objname+".ACTIONS['"+d['p']+"']()", false); else QueuePersonScript(sprite,this.ACTIONS[d['p']], false); break;
		case "#": QueuePersonScript(sprite, this.objname+".EMOTIONS['"+d['p']+"']()", false); break;
		case "": return 0; break;
	}

	if(!d['moving'])
		--d['step'];
	else{
		if( ((d['x']+d['move_xx'])!=GetPersonXFloat(sprite)) && ((d['y']+d['move_yy'])!=GetPersonYFloat(sprite)) ) {
			//round float. Obscene Sphere/Javascript bug.
			SetPersonX(sprite,d['x']+d['move_xx']);
			SetPersonY(sprite,d['y']+d['move_yy']);
			d['x']=GetPersonXFloat(sprite);
			d['y']=GetPersonYFloat(sprite);
			--d['step'];
		}
		else --d['step'];
	}
	SetPersonData(sprite,d);
	return 1;
}

/**
 * Internal function. Used by {@link DoMove}. If calculates the next movement in the mstr.
 */
LithoniteEngine.prototype.DoMoveCalc = function(sprite,d) {
	d['step']=1;
	if(d['mstr'].length <= d['pos']){
		if(!d['repeat']){
			this.ClearCGMove(sprite,false,d);return 0;} //clearQ if not repeating.
		else d['pos']=0;
	}
	if(!d['pos']||(d['mstr_cutme'])){
		d['pos']=0; //Pos=0 if we are beyond string or is undefined.
		if(d['mstr_cutme']){ //Remove pre-continuation of move
			d['mstr']= d['mstr'].substring(d['mstr_cutme']);
			d['mstr_cutme']=0;
		}
	}
	if(!d['factor']){
		if(d['half']){
			d['half']=false;
			SetPersonSpeedXY(sprite,d['spd_x'],d['spd_y']);
		}
		d['factorX']=Math.round(16/GetPersonSpeedX(sprite)); // These should be recalculated if changepersonspeed
		d['factorY']=Math.round(16/GetPersonSpeedY(sprite));
		d['factor']=d['factorX']; //assume same speed for X and Y
	}
	d['c']=d['mstr'].charAt(d['pos']++);  //c=movementdir (index=pos)
	d['t']=1; //t=multiplier for step: "n6" => t=6
	//Consider multiplier (d['t']) only for letters (nsweh etc)
	var isletter = ((d['c'].toUpperCase().charCodeAt(0)>64) && (d['c'].toUpperCase().charCodeAt(0)<91));
	if(d['mstr'].charAt(d['pos'])>0 && isletter){
		d['t']="";
		while( d['mstr'].charCodeAt(d['pos'])==48 || d['mstr'].charAt(d['pos'])>0 ){ 
			d['t']+=d['mstr'].charAt(d['pos']++);
		}
		d['t']=parseInt(d['t']);
	}
	//Other chars are special functions (like @,+,-,=,! and #), which always have a parameter (d['p'])
	else if(!isletter) d['p']=d['mstr'].charAt(d['pos']++);
	d['move_x']=0;d['move_y']=0;d['moving']=0;
	switch(d['c'])
	{
		case "H":case "A":d['step']=d['factor'];break;
		case "C": d['step']=this.getSeqTimes(sprite); break;
		case "q":d['move_x']=-1;this.saveAndHalfSpeed(sprite,d,-1,-1);
		case "n":d['step']=d['factorY'];
		case "u":d['move_y']=-1;d['moving']=2;break;
		case "o":d['move_y']=-1;this.saveAndHalfSpeed(sprite,d,-1,-1);
		case "e":d['step']=d['factorX'];
		case "r":d['move_x']=1;d['moving']=2;break;
		case "m":d['move_x']=1;this.saveAndHalfSpeed(sprite,d,1,1);
		case "s":d['step']=d['factorY'];
		case "d":d['move_y']=1;d['moving']=2;break;
		case "z":d['move_y']=1;this.saveAndHalfSpeed(sprite,d,1,1);
		case "w":d['step']=d['factorX'];
		case "l":d['move_x']=-1;d['moving']=2;break;
		case "p":d['step']=(d['factor']>>1);break;
		case "U": case "N":d['hist_x']=0;d['hist_y']=-1;break;
		case "R": case "E":d['hist_x']=1;d['hist_y']=0;break;
		case "L": case "W":d['hist_x']=-1;d['hist_y']=0;break;
		case "D": case "S":d['hist_x']=0;d['hist_y']=1;break;
		case "T": case "Q":d['hist_x']=-1;d['hist_y']=-1;break;
		case "Y": case "O":d['hist_x']=1;d['hist_y']=-1;break;
		case "B": case "M":d['hist_x']=1;d['hist_y']=1;break;
		case "V": case "Z":d['hist_x']=-1;d['hist_y']=1;break;
		default: return; break;
	}
	d['step']*=d['t'];
	d['move_xx']=d['move_x']*GetPersonSpeedX(sprite);
	d['move_yy']=d['move_y']*GetPersonSpeedY(sprite);
	if(sprite!=this.GIP)return;
	if(d['moving']>0){
		this.hist_x=this.move_x;
		this.hist_y=this.move_y;
		this.idle=0;
		this.move_x=d['move_x'];
		this.move_y=d['move_y'];
		this.moving=d['moving'];
		this.deObstruct();
		this.doZone();
	}else{
		this.hist_x=d['hist_x'];
		this.hist_y=d['hist_y'];
		this.idle=0;
		this.move_x=d['move_x'];
		this.move_y=d['move_y'];
		if(!d['noidle']) this.standStill();
	}
}

// Internal AddCGMove/DoMoveCalc function, makes the sprite move half as fast for diagonal movement
LithoniteEngine.prototype.saveAndHalfSpeed = function(sprite, d,x,y){
	d['half'] = true;
	d['spd_x']=GetPersonSpeedX(sprite);
	d['spd_y']=GetPersonSpeedY(sprite);
	SetPersonSpeedXY(sprite,d['spd_x']/2,d['spd_y']/2);
	d['factorX']=Math.round(16/GetPersonSpeedX(sprite)/2) +x;
	d['factorY']=Math.round(16/GetPersonSpeedY(sprite)/2) +y;
	d['factor']=0;
}


//----- RANDOM WALK -----//

/**
 * Makes NPC's walk randomly. (needs optimizing)
 * @param {string} name Name of the person
 * @param {integer} waitLength How slow it will be.
 * @param {integer} stepLength By default 1. Set to 2 to run.
 */
LithoniteEngine.prototype.walkRandom = function(name, waitLength, stepLength){
	if(!waitLength) waitLength = 0;
	if(!stepLength) stepLength = 1;
	var random = Math.floor(Math.random()*20);
	var action;
	var go_x=0; var go_y=0;

	//Get Previous direction, and continue walking in that direction
	switch(GetPersonDirection(name)){
		case("north"): action = COMMAND_MOVE_NORTH; go_x=0;go_y=-1; break;
		case("east"):  action = COMMAND_MOVE_EAST; go_x=1;go_y=0; break;
		case("south"): action = COMMAND_MOVE_SOUTH; go_x=0;go_y=1; break;
		case("west"):  action = COMMAND_MOVE_WEST; go_x=-1;go_y=0; break;
	}

	//Unless, of course, it cannot walk that way. In that case, roll the directional dices again.
	if(Math.random()<0.002 || IsPersonObstructed( name, GetPersonX(name)+go_x*16, GetPersonY(name)+go_y*16)) {
		random = Math.floor(Math.random()*5);
		switch(random){
			case(0): action = COMMAND_WAIT; break;
			case(1): action = COMMAND_MOVE_NORTH; break;
			case(2): action = COMMAND_MOVE_EAST; break;
			case(3): action = COMMAND_MOVE_SOUTH; break;
			case(4): action = COMMAND_MOVE_WEST; break;
		}
	}
 
	//Now do what we wanted to do
	switch(action){
		case(COMMAND_WAIT): /*SetPersonFrame(name, 0);*/ QueuePersonCommand(name, COMMAND_WAIT, true); break;
		case(COMMAND_MOVE_NORTH): QueuePersonCommand(name, COMMAND_FACE_NORTH, true); break;
		case(COMMAND_MOVE_EAST):  QueuePersonCommand(name, COMMAND_FACE_EAST, true); break;
		case(COMMAND_MOVE_SOUTH): QueuePersonCommand(name, COMMAND_FACE_SOUTH, true); break;
		case(COMMAND_MOVE_WEST):  QueuePersonCommand(name, COMMAND_FACE_WEST, true); break;
	}

	var i=16;
	do{
		var j=stepLength;
		do{
			QueuePersonCommand(name, action, false);
		}while(--j);
		j=waitLength;
		do{
			QueuePersonCommand(name, COMMAND_WAIT, false);
		}while(--j);
	}while(--i);
}




/*
   StepTo - Pathfinding algorithm. Pacman/Xrally alike.
   AI is very poor, but the algorithm is fast. (even faster once you remove the comments and empty lines)
  StepTo returns a string that can be fed to SetCGMove to move.
  ================================================-----
  Usage:
	var me=GetCurrentPerson();
	var doIgnorePersonObstructions = false;
	var repeat=false;
	var mstr=Lithonite.StepTo(me,MainChar,16);
	Lithonite.SetCGMove(me , mstr ,doIgnorePersonObstructions ,repeat) // maybe even add: if(IsCommandQueueEmpty(me))

	Inside a SCRIPT_COMMAND_GENERATOR for a ghost in PacMan:
		Lithonite.SetCGMove(GetCurrentPerson(), Lithonite.StepTo(GetCurrentPerson(),"Pacman",16) ,true, false) ;
*/

/**
 * Helper Sorting Function for StepTo Array of objects {d:direction=<string>, n:distance=<number>}: compare Numbers
 */
LithoniteEngine.prototype.StepToSort=function(a,b){return a.n-b.n;}

/**
 * Predicts how to get to destination
 * @param {string} me Name of the person who wil walk
 * @param {string} other Name of a person we want to walk to
 * @returns a string that can be fed to SetCGMove to move
 */
LithoniteEngine.prototype.StepToPerson = function(me,other,tilesize){
	return this.StepToXY(me,GetPersonX(other),GetPersonY(other),tilesize)
}

LithoniteEngine.prototype.StepToXY = function(me,XX,YY,tilesize) {
 var baseDistance= -Math.abs(GetPersonX(me)-XX) - Math.abs(GetPersonY(me)-YY); //The more negative, the better route and faster than pythagoras

if((tilesize>1)&&((GetPersonX(me)%16!=7)||(GetPersonY(me)%16!=7)))tilesize=1; //Allign to 16x16 grid 
//(7 because car center is not at the border of the obstruction but in the center.)

 var A = new Array();
A.length=0; //Seems to be nagging about this...
 if(baseDistance>-32)	//We are so close, we get obstructed. Go into Kamikaze mode!
 {
	var hor= (GetPersonX(me)>XX)? tilesize : -tilesize;
	var ver= (GetPersonY(me)>YY)? tilesize : -tilesize;
   	A[A.length]={d:"Ww",n:baseDistance-hor}; 
	if(GetPersonDirection(me)=="east") {A[A.length-1].n>>=2;} //Penalize going back
 	A[A.length]={d:"Ee",n:baseDistance+hor}; 
	if(GetPersonDirection(me)=="west") {A[A.length-1].n>>=2;} //Penalize going back
	A[A.length]={d:"Nn",n:baseDistance-ver};
	if(GetPersonDirection(me)=="south")  {A[A.length-1].n>>=2;} //Penalize going back
	A[A.length]={d:"Ss",n:baseDistance+ver}; 
	if(GetPersonDirection(me)=="north") {A[A.length-1].n>>=2;} //Penalize going back
 }
 else
 {
  var hor=(GetPersonX(me)>XX)?tilesize:-tilesize;
  if(Math.abs(GetPersonX(me)-XX)<tilesize) hor=0;
  if(!IsPersonObstructed(me, GetPersonX(me)-tilesize, GetPersonY(me)))	{ //west
 	A[A.length]={d:"Ww1",n:baseDistance-hor}; 
	if(GetPersonDirection(me)=="east") {A[A.length-1].n>>=3;} //Penalize going back
	//if(GetPersonDirection(me)=="west")  {A[A.length-1].n-=2;} //Favour continue same direction
  }
  if(!IsPersonObstructed(me, GetPersonX(me)+tilesize, GetPersonY(me)))	{ //east
 	A[A.length]={d:"Ee1",n:baseDistance+hor}; 
	if(GetPersonDirection(me)=="west") {A[A.length-1].n>>=3;} //Penalize going back
	//if(GetPersonDirection(me)=="east")  {A[A.length-1].n-=2;} //Favour continue same direction
  }

  var ver= (GetPersonY(me)>YY)? tilesize : -tilesize;
  if(Math.abs(GetPersonY(me)-YY)<tilesize) ver=0;
  if(	( !IsPersonObstructed(me, GetPersonX(me), GetPersonY(me)-tilesize) ) 
	//&&	( !IsPersonObstructed(me, GetPersonX(me), GetPersonY(me)-tilesize/16) )
	)  { //north
	A[A.length]={d:"Nn1",n:baseDistance-ver};
	if(GetPersonDirection(me)=="south")  {A[A.length-1].n>>=3;} //Penalize going back
	//if (GetPersonDirection(me)=="north")  {A[A.length-1].n-=2;} //Favour continue same direction
  }
  if(!IsPersonObstructed(me, GetPersonX(me), GetPersonY(me)+tilesize) )	{ //south
 	A[A.length]={d:"Ss1",n:baseDistance+ver}; 
	if(GetPersonDirection(me)=="north") {A[A.length-1].n>>=3;} //Penalize going back
	//if (GetPersonDirection(me)=="south")  {A[A.length-1].n-=2;} //Favour continue same direction
  }
 }
 if(A.length>1) A=A.sort(this.StepToSort); //Dont sort empty or 1 element array.

//if (typeof(A[0]) != undefined) //Cannot test on this, function abends
if(A.length>0)
{
 if (A.length == 1) return A[0].d;
 if (A[0].n==A[1].n) return A[Math.floor(Math.random()*2)].d; //Try to go random for equally good directions
 return A[0].d;
}
 else 
 if(tilesize>1) return this.StepToXY(me,XX,YY,1); //We are not alligned to a 16x16 grid... do steps of 1 pixel
}

//================================================-----/
//TODO: make an NPC pushable by the PC when NPC is obstructed by the PC.

/**
 * Extends lithonite with deObstruct for NPC
 * @param {string} person The name of the person to deobstruct
 * @param {integer} move_x Lithonite X vector for person
 * @param {integer} move_y Lithonite Y vector for person
 * @returns true if NPC was deobstructed, false if not.
 */
LithoniteEngine.prototype.deObstructNPC = function(person,move_x,move_y) {
 person = person || GetCurrentPerson(); 
 if (move_x == undefined) move_x = GetPersonValue(person,'move_x');
 if (move_y == undefined) move_y = GetPersonValue(person,'move_y');
 var $GPX = GetPersonX(person);
 var $GPY = GetPersonY(person);
 var $GPXX= $GPX+(move_x<<1);
 var $GPYY= $GPY+(move_y<<1);
 if(IsPersonObstructed(person,$GPXX,$GPYY))
  {
   var $domoveL=0; var $domoveR=0;
   var $dHI=0; var $dVI=0;
   var $i=move_x?this.LMaxLookupX-1:this.LMaxLookupY-1;
   do{
    $dHI=move_y*$i; $dVI=move_x*$i;
    $domoveL+=!IsPersonObstructed(person,$GPXX+$dHI,$GPYY-$dVI);
    $domoveR+=!IsPersonObstructed(person,$GPXX-$dHI,$GPYY+$dVI);
   }while($i--);
   if($domoveL && ($domoveL>=$domoveR) &&
	(!IsPersonObstructed(person,$GPX+move_y,$GPY-move_x)))
   {
    SetPersonX(person,$GPX+move_y);
    SetPersonY(person,$GPY-move_x);
    return true;
   }
   else if($domoveR && 
	(!IsPersonObstructed(person,$GPX-move_y,$GPY+move_x)))
   {
    SetPersonX(person,$GPX-move_y);
    SetPersonY(person,$GPY+move_x);
    return true;
   }
   if(!$domoveL&&!$domoveR&&GetObstructingPerson(person,$GPXX,$GPYY)&&(GetPersonValue(person,'push')))
    CallPersonScript(GetObstructingPerson(person,$GPXX,$GPYY), SCRIPT_ON_ACTIVATE_TOUCH);
  }
 return false;
}

/**
 * Extends lithonite with idle movement
 * for this, you need idle_<dir> directions in your spriteset, for example: idle_south 
 * A good place to Add Lithonite.doIdle(); is in the Render Update.
 * 
 */
LithoniteEngine.prototype.doIdle = function(){
	if (this.idle > 600) {
		var dir = GetPersonDirection(this.GIP);
		if(!this.idlesteps)
			dir = "idle_" + this.getMoveDir(this.hist_x,this.hist_y);
			// For randomized directions, use something like this:
			//  dir = ["carried", "glomped_west"][Math.floor(Math.random()*2)];
		if ( this.idlesteps = this.idlesteps || this.getSeqTimes(this.GIP, dir) ) {
			if(--this.idlesteps == 0) {
				Lithonite.standStill();
				return this.idle = 1;
			}
			SetPersonDirection(this.GIP, dir);
			QueuePersonCommand(this.GIP, COMMAND_ANIMATE, false);
		} else {
			this.idle = 1;
		}
	} else {
		this.idlesteps = 0;
	}
}


